package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{HeaderRow, Delimiter}
import scala.jdk.CollectionConverters.*
final case class CsvOptions(
    delimiter: Option[Delimiter] = None,
    headerRow: Option[HeaderRow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CsvOptions = {
    import CsvOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CsvOptions
      .builder()
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(
        headerRow.map(value => HeaderRow.unwrap(value): java.lang.Boolean)
      )(_.headerRow)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CsvOptions.ReadOnly =
    zio.aws.databrew.model.CsvOptions.wrap(buildAwsValue())
}
object CsvOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CsvOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CsvOptions = zio.aws.databrew.model
      .CsvOptions(delimiter.map(value => value), headerRow.map(value => value))
    def delimiter: Option[Delimiter]
    def headerRow: Option[HeaderRow]
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getHeaderRow: ZIO[Any, AwsError, HeaderRow] =
      AwsError.unwrapOptionField("headerRow", headerRow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CsvOptions
  ) extends zio.aws.databrew.model.CsvOptions.ReadOnly {
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.databrew.model.primitives.Delimiter(value))
    override val headerRow: Option[HeaderRow] = scala
      .Option(impl.headerRow())
      .map(value => zio.aws.databrew.model.primitives.HeaderRow(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CsvOptions
  ): zio.aws.databrew.model.CsvOptions.ReadOnly = new Wrapper(impl)
}
