package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  LocaleCode,
  TimezoneOffset,
  DatetimeFormat
}
import scala.jdk.CollectionConverters.*
final case class DatetimeOptions(
    format: DatetimeFormat,
    timezoneOffset: Option[TimezoneOffset] = None,
    localeCode: Option[LocaleCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DatetimeOptions = {
    import DatetimeOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DatetimeOptions
      .builder()
      .format(DatetimeFormat.unwrap(format): java.lang.String)
      .optionallyWith(
        timezoneOffset.map(value =>
          TimezoneOffset.unwrap(value): java.lang.String
        )
      )(_.timezoneOffset)
      .optionallyWith(
        localeCode.map(value => LocaleCode.unwrap(value): java.lang.String)
      )(_.localeCode)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DatetimeOptions.ReadOnly =
    zio.aws.databrew.model.DatetimeOptions.wrap(buildAwsValue())
}
object DatetimeOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DatetimeOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DatetimeOptions =
      zio.aws.databrew.model.DatetimeOptions(
        format,
        timezoneOffset.map(value => value),
        localeCode.map(value => value)
      )
    def format: DatetimeFormat
    def timezoneOffset: Option[TimezoneOffset]
    def localeCode: Option[LocaleCode]
    def getFormat: ZIO[Any, Nothing, DatetimeFormat] = ZIO.succeed(format)
    def getTimezoneOffset: ZIO[Any, AwsError, TimezoneOffset] =
      AwsError.unwrapOptionField("timezoneOffset", timezoneOffset)
    def getLocaleCode: ZIO[Any, AwsError, LocaleCode] =
      AwsError.unwrapOptionField("localeCode", localeCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DatetimeOptions
  ) extends zio.aws.databrew.model.DatetimeOptions.ReadOnly {
    override val format: DatetimeFormat =
      zio.aws.databrew.model.primitives.DatetimeFormat(impl.format())
    override val timezoneOffset: Option[TimezoneOffset] = scala
      .Option(impl.timezoneOffset())
      .map(value => zio.aws.databrew.model.primitives.TimezoneOffset(value))
    override val localeCode: Option[LocaleCode] = scala
      .Option(impl.localeCode())
      .map(value => zio.aws.databrew.model.primitives.LocaleCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DatetimeOptions
  ): zio.aws.databrew.model.DatetimeOptions.ReadOnly = new Wrapper(impl)
}
