package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  OverwriteOutput,
  TableName,
  DatabaseName,
  CatalogId
}
import scala.jdk.CollectionConverters.*
final case class DataCatalogOutput(
    catalogId: Option[CatalogId] = None,
    databaseName: DatabaseName,
    tableName: TableName,
    s3Options: Option[zio.aws.databrew.model.S3TableOutputOptions] = None,
    databaseOptions: Option[zio.aws.databrew.model.DatabaseTableOutputOptions] =
      None,
    overwrite: Option[OverwriteOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DataCatalogOutput = {
    import DataCatalogOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DataCatalogOutput
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogId.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(s3Options.map(value => value.buildAwsValue()))(
        _.s3Options
      )
      .optionallyWith(databaseOptions.map(value => value.buildAwsValue()))(
        _.databaseOptions
      )
      .optionallyWith(
        overwrite.map(value => OverwriteOutput.unwrap(value): java.lang.Boolean)
      )(_.overwrite)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DataCatalogOutput.ReadOnly =
    zio.aws.databrew.model.DataCatalogOutput.wrap(buildAwsValue())
}
object DataCatalogOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DataCatalogOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DataCatalogOutput =
      zio.aws.databrew.model.DataCatalogOutput(
        catalogId.map(value => value),
        databaseName,
        tableName,
        s3Options.map(value => value.asEditable),
        databaseOptions.map(value => value.asEditable),
        overwrite.map(value => value)
      )
    def catalogId: Option[CatalogId]
    def databaseName: DatabaseName
    def tableName: TableName
    def s3Options: Option[zio.aws.databrew.model.S3TableOutputOptions.ReadOnly]
    def databaseOptions
        : Option[zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly]
    def overwrite: Option[OverwriteOutput]
    def getCatalogId: ZIO[Any, AwsError, CatalogId] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getS3Options: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.S3TableOutputOptions.ReadOnly
    ] = AwsError.unwrapOptionField("s3Options", s3Options)
    def getDatabaseOptions: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly
    ] = AwsError.unwrapOptionField("databaseOptions", databaseOptions)
    def getOverwrite: ZIO[Any, AwsError, OverwriteOutput] =
      AwsError.unwrapOptionField("overwrite", overwrite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DataCatalogOutput
  ) extends zio.aws.databrew.model.DataCatalogOutput.ReadOnly {
    override val catalogId: Option[CatalogId] = scala
      .Option(impl.catalogId())
      .map(value => zio.aws.databrew.model.primitives.CatalogId(value))
    override val databaseName: DatabaseName =
      zio.aws.databrew.model.primitives.DatabaseName(impl.databaseName())
    override val tableName: TableName =
      zio.aws.databrew.model.primitives.TableName(impl.tableName())
    override val s3Options
        : Option[zio.aws.databrew.model.S3TableOutputOptions.ReadOnly] = scala
      .Option(impl.s3Options())
      .map(value => zio.aws.databrew.model.S3TableOutputOptions.wrap(value))
    override val databaseOptions
        : Option[zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly] =
      scala
        .Option(impl.databaseOptions())
        .map(value =>
          zio.aws.databrew.model.DatabaseTableOutputOptions.wrap(value)
        )
    override val overwrite: Option[OverwriteOutput] = scala
      .Option(impl.overwrite())
      .map(value => zio.aws.databrew.model.primitives.OverwriteOutput(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DataCatalogOutput
  ): zio.aws.databrew.model.DataCatalogOutput.ReadOnly = new Wrapper(impl)
}
