package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  TargetColumn,
  ConditionValue,
  Condition
}
import scala.jdk.CollectionConverters.*
final case class ConditionExpression(
    condition: Condition,
    value: Option[ConditionValue] = None,
    targetColumn: TargetColumn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ConditionExpression = {
    import ConditionExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ConditionExpression
      .builder()
      .condition(Condition.unwrap(condition): java.lang.String)
      .optionallyWith(
        value.map(value => ConditionValue.unwrap(value): java.lang.String)
      )(_.value)
      .targetColumn(TargetColumn.unwrap(targetColumn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ConditionExpression.ReadOnly =
    zio.aws.databrew.model.ConditionExpression.wrap(buildAwsValue())
}
object ConditionExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ConditionExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ConditionExpression =
      zio.aws.databrew.model
        .ConditionExpression(condition, value.map(value => value), targetColumn)
    def condition: Condition
    def value: Option[ConditionValue]
    def targetColumn: TargetColumn
    def getCondition: ZIO[Any, Nothing, Condition] = ZIO.succeed(condition)
    def getValue: ZIO[Any, AwsError, ConditionValue] =
      AwsError.unwrapOptionField("value", value)
    def getTargetColumn: ZIO[Any, Nothing, TargetColumn] =
      ZIO.succeed(targetColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ConditionExpression
  ) extends zio.aws.databrew.model.ConditionExpression.ReadOnly {
    override val condition: Condition =
      zio.aws.databrew.model.primitives.Condition(impl.condition())
    override val value: Option[ConditionValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.databrew.model.primitives.ConditionValue(value))
    override val targetColumn: TargetColumn =
      zio.aws.databrew.model.primitives.TargetColumn(impl.targetColumn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ConditionExpression
  ): zio.aws.databrew.model.ConditionExpression.ReadOnly = new Wrapper(impl)
}
