package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecipeStep(
    action: zio.aws.databrew.model.RecipeAction,
    conditionExpressions: Option[
      Iterable[zio.aws.databrew.model.ConditionExpression]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RecipeStep = {
    import RecipeStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RecipeStep
      .builder()
      .action(action.buildAwsValue())
      .optionallyWith(
        conditionExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditionExpressions)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RecipeStep.ReadOnly =
    zio.aws.databrew.model.RecipeStep.wrap(buildAwsValue())
}
object RecipeStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RecipeStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RecipeStep =
      zio.aws.databrew.model.RecipeStep(
        action.asEditable,
        conditionExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def action: zio.aws.databrew.model.RecipeAction.ReadOnly
    def conditionExpressions
        : Option[List[zio.aws.databrew.model.ConditionExpression.ReadOnly]]
    def getAction
        : ZIO[Any, Nothing, zio.aws.databrew.model.RecipeAction.ReadOnly] =
      ZIO.succeed(action)
    def getConditionExpressions: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ConditionExpression.ReadOnly
    ]] =
      AwsError.unwrapOptionField("conditionExpressions", conditionExpressions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RecipeStep
  ) extends zio.aws.databrew.model.RecipeStep.ReadOnly {
    override val action: zio.aws.databrew.model.RecipeAction.ReadOnly =
      zio.aws.databrew.model.RecipeAction.wrap(impl.action())
    override val conditionExpressions
        : Option[List[zio.aws.databrew.model.ConditionExpression.ReadOnly]] =
      scala
        .Option(impl.conditionExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.ConditionExpression.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RecipeStep
  ): zio.aws.databrew.model.RecipeStep.ReadOnly = new Wrapper(impl)
}
