package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{NextToken, MaxResults100, JobName}
import scala.jdk.CollectionConverters.*
final case class ListSchedulesRequest(
    jobName: Option[JobName] = None,
    maxResults: Option[MaxResults100] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListSchedulesRequest = {
    import ListSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListSchedulesRequest.ReadOnly =
    zio.aws.databrew.model.ListSchedulesRequest.wrap(buildAwsValue())
}
object ListSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListSchedulesRequest =
      zio.aws.databrew.model.ListSchedulesRequest(
        jobName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobName: Option[JobName]
    def maxResults: Option[MaxResults100]
    def nextToken: Option[NextToken]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ) extends zio.aws.databrew.model.ListSchedulesRequest.ReadOnly {
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.databrew.model.primitives.JobName(value))
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesRequest
  ): zio.aws.databrew.model.ListSchedulesRequest.ReadOnly = new Wrapper(impl)
}
