package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{NextToken, MaxResults100, Arn}
import scala.jdk.CollectionConverters.*
final case class ListRulesetsRequest(
    targetArn: Option[Arn] = None,
    maxResults: Option[MaxResults100] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRulesetsRequest = {
    import ListRulesetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRulesetsRequest
      .builder()
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRulesetsRequest.ReadOnly =
    zio.aws.databrew.model.ListRulesetsRequest.wrap(buildAwsValue())
}
object ListRulesetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRulesetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRulesetsRequest =
      zio.aws.databrew.model.ListRulesetsRequest(
        targetArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def targetArn: Option[Arn]
    def maxResults: Option[MaxResults100]
    def nextToken: Option[NextToken]
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRulesetsRequest
  ) extends zio.aws.databrew.model.ListRulesetsRequest.ReadOnly {
    override val targetArn: Option[Arn] = scala
      .Option(impl.targetArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRulesetsRequest
  ): zio.aws.databrew.model.ListRulesetsRequest.ReadOnly = new Wrapper(impl)
}
