package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.RecipeName
import scala.jdk.CollectionConverters.*
final case class BatchDeleteRecipeVersionResponse(
    name: RecipeName,
    errors: Option[Iterable[zio.aws.databrew.model.RecipeVersionErrorDetail]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse = {
    import BatchDeleteRecipeVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly =
    zio.aws.databrew.model.BatchDeleteRecipeVersionResponse
      .wrap(buildAwsValue())
}
object BatchDeleteRecipeVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.BatchDeleteRecipeVersionResponse =
      zio.aws.databrew.model.BatchDeleteRecipeVersionResponse(
        name,
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: RecipeName
    def errors
        : Option[List[zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly]]
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse
  ) extends zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val errors: Option[
      List[zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.RecipeVersionErrorDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionResponse
  ): zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly =
    new Wrapper(impl)
}
