package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait OutputFormat {
  def unwrap: software.amazon.awssdk.services.databrew.model.OutputFormat
}
object OutputFormat {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.OutputFormat
  ): zio.aws.databrew.model.OutputFormat = value match {
    case software.amazon.awssdk.services.databrew.model.OutputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.PARQUET =>
      val r = PARQUET
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.GLUEPARQUET =>
      val r = GLUEPARQUET
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.AVRO =>
      val r = AVRO
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.ORC =>
      val r = ORC
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.XML =>
      val r = XML
      r
    case software.amazon.awssdk.services.databrew.model.OutputFormat.TABLEAUHYPER =>
      val r = TABLEAUHYPER
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.CSV
  }
  case object JSON extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.JSON
  }
  case object PARQUET extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.PARQUET
  }
  case object GLUEPARQUET extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.GLUEPARQUET
  }
  case object AVRO extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.AVRO
  }
  case object ORC extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.ORC
  }
  case object XML extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.XML
  }
  case object TABLEAUHYPER extends zio.aws.databrew.model.OutputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.OutputFormat =
      software.amazon.awssdk.services.databrew.model.OutputFormat.TABLEAUHYPER
  }
}
