package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{RecipeVersion, RecipeName}
import scala.jdk.CollectionConverters.*
final case class RecipeReference(
    name: RecipeName,
    recipeVersion: Option[RecipeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RecipeReference = {
    import RecipeReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RecipeReference
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .optionallyWith(
        recipeVersion.map(value =>
          RecipeVersion.unwrap(value): java.lang.String
        )
      )(_.recipeVersion)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RecipeReference.ReadOnly =
    zio.aws.databrew.model.RecipeReference.wrap(buildAwsValue())
}
object RecipeReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RecipeReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RecipeReference =
      zio.aws.databrew.model
        .RecipeReference(name, recipeVersion.map(value => value))
    def name: RecipeName
    def recipeVersion: Option[RecipeVersion]
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getRecipeVersion: ZIO[Any, AwsError, RecipeVersion] =
      AwsError.unwrapOptionField("recipeVersion", recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RecipeReference
  ) extends zio.aws.databrew.model.RecipeReference.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val recipeVersion: Option[RecipeVersion] = scala
      .Option(impl.recipeVersion())
      .map(value => zio.aws.databrew.model.primitives.RecipeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RecipeReference
  ): zio.aws.databrew.model.RecipeReference.ReadOnly = new Wrapper(impl)
}
