package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  ProjectName,
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  Arn,
  DatasetName,
  OpenedBy,
  CreatedBy,
  RecipeName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Project(
    accountId: Option[AccountId] = None,
    createDate: Option[Date] = None,
    createdBy: Option[CreatedBy] = None,
    datasetName: Option[DatasetName] = None,
    lastModifiedDate: Option[Date] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    name: ProjectName,
    recipeName: RecipeName,
    resourceArn: Option[Arn] = None,
    sample: Option[zio.aws.databrew.model.Sample] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    roleArn: Option[Arn] = None,
    openedBy: Option[OpenedBy] = None,
    openDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Project
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .name(ProjectName.unwrap(name): java.lang.String)
      .recipeName(RecipeName.unwrap(recipeName): java.lang.String)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(sample.map(value => value.buildAwsValue()))(_.sample)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        openedBy.map(value => OpenedBy.unwrap(value): java.lang.String)
      )(_.openedBy)
      .optionallyWith(openDate.map(value => Date.unwrap(value): Instant))(
        _.openDate
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Project.ReadOnly =
    zio.aws.databrew.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Project] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Project =
      zio.aws.databrew.model.Project(
        accountId.map(value => value),
        createDate.map(value => value),
        createdBy.map(value => value),
        datasetName.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        name,
        recipeName,
        resourceArn.map(value => value),
        sample.map(value => value.asEditable),
        tags.map(value => value),
        roleArn.map(value => value),
        openedBy.map(value => value),
        openDate.map(value => value)
      )
    def accountId: Option[AccountId]
    def createDate: Option[Date]
    def createdBy: Option[CreatedBy]
    def datasetName: Option[DatasetName]
    def lastModifiedDate: Option[Date]
    def lastModifiedBy: Option[LastModifiedBy]
    def name: ProjectName
    def recipeName: RecipeName
    def resourceArn: Option[Arn]
    def sample: Option[zio.aws.databrew.model.Sample.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def roleArn: Option[Arn]
    def openedBy: Option[OpenedBy]
    def openDate: Option[Date]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getRecipeName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(recipeName)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getSample: ZIO[Any, AwsError, zio.aws.databrew.model.Sample.ReadOnly] =
      AwsError.unwrapOptionField("sample", sample)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getOpenedBy: ZIO[Any, AwsError, OpenedBy] =
      AwsError.unwrapOptionField("openedBy", openedBy)
    def getOpenDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("openDate", openDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Project
  ) extends zio.aws.databrew.model.Project.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val recipeName: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.recipeName())
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val sample: Option[zio.aws.databrew.model.Sample.ReadOnly] = scala
      .Option(impl.sample())
      .map(value => zio.aws.databrew.model.Sample.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val roleArn: Option[Arn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val openedBy: Option[OpenedBy] = scala
      .Option(impl.openedBy())
      .map(value => zio.aws.databrew.model.primitives.OpenedBy(value))
    override val openDate: Option[Date] = scala
      .Option(impl.openDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Project
  ): zio.aws.databrew.model.Project.ReadOnly = new Wrapper(impl)
}
