package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.JobSize
import scala.jdk.CollectionConverters.*
final case class JobSample(
    mode: Option[zio.aws.databrew.model.SampleMode] = None,
    size: Option[JobSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.JobSample = {
    import JobSample.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.JobSample
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(size.map(value => JobSize.unwrap(value): java.lang.Long))(
        _.size
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.JobSample.ReadOnly =
    zio.aws.databrew.model.JobSample.wrap(buildAwsValue())
}
object JobSample {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.JobSample
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.JobSample = zio.aws.databrew.model
      .JobSample(mode.map(value => value), size.map(value => value))
    def mode: Option[zio.aws.databrew.model.SampleMode]
    def size: Option[JobSize]
    def getMode: ZIO[Any, AwsError, zio.aws.databrew.model.SampleMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getSize: ZIO[Any, AwsError, JobSize] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.JobSample
  ) extends zio.aws.databrew.model.JobSample.ReadOnly {
    override val mode: Option[zio.aws.databrew.model.SampleMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.databrew.model.SampleMode.wrap(value))
    override val size: Option[JobSize] = scala
      .Option(impl.size())
      .map(value => zio.aws.databrew.model.primitives.JobSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.JobSample
  ): zio.aws.databrew.model.JobSample.ReadOnly = new Wrapper(impl)
}
