package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  RecipeVersion,
  RecipeErrorMessage,
  ErrorCode
}
import scala.jdk.CollectionConverters.*
final case class RecipeVersionErrorDetail(
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[RecipeErrorMessage] = None,
    recipeVersion: Option[RecipeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail = {
    import RecipeVersionErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value =>
          RecipeErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        recipeVersion.map(value =>
          RecipeVersion.unwrap(value): java.lang.String
        )
      )(_.recipeVersion)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly =
    zio.aws.databrew.model.RecipeVersionErrorDetail.wrap(buildAwsValue())
}
object RecipeVersionErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RecipeVersionErrorDetail =
      zio.aws.databrew.model.RecipeVersionErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        recipeVersion.map(value => value)
      )
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[RecipeErrorMessage]
    def recipeVersion: Option[RecipeVersion]
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, RecipeErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getRecipeVersion: ZIO[Any, AwsError, RecipeVersion] =
      AwsError.unwrapOptionField("recipeVersion", recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail
  ) extends zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly {
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.databrew.model.primitives.ErrorCode(value))
    override val errorMessage: Option[RecipeErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.databrew.model.primitives.RecipeErrorMessage(value))
    override val recipeVersion: Option[RecipeVersion] = scala
      .Option(impl.recipeVersion())
      .map(value => zio.aws.databrew.model.primitives.RecipeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail
  ): zio.aws.databrew.model.RecipeVersionErrorDetail.ReadOnly = new Wrapper(
    impl
  )
}
