package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  Date,
  LastModifiedBy,
  TagValue,
  Arn,
  DatasetName,
  CreatedBy,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetResponse(
    createdBy: Option[CreatedBy] = None,
    createDate: Option[Date] = None,
    name: DatasetName,
    format: Option[zio.aws.databrew.model.InputFormat] = None,
    formatOptions: Option[zio.aws.databrew.model.FormatOptions] = None,
    input: zio.aws.databrew.model.Input,
    lastModifiedDate: Option[Date] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    source: Option[zio.aws.databrew.model.Source] = None,
    pathOptions: Option[zio.aws.databrew.model.PathOptions] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    resourceArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .name(DatasetName.unwrap(name): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .input(input.buildAwsValue())
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(pathOptions.map(value => value.buildAwsValue()))(
        _.pathOptions
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.databrew.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeDatasetResponse =
      zio.aws.databrew.model.DescribeDatasetResponse(
        createdBy.map(value => value),
        createDate.map(value => value),
        name,
        format.map(value => value),
        formatOptions.map(value => value.asEditable),
        input.asEditable,
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        source.map(value => value),
        pathOptions.map(value => value.asEditable),
        tags.map(value => value),
        resourceArn.map(value => value)
      )
    def createdBy: Option[CreatedBy]
    def createDate: Option[Date]
    def name: DatasetName
    def format: Option[zio.aws.databrew.model.InputFormat]
    def formatOptions: Option[zio.aws.databrew.model.FormatOptions.ReadOnly]
    def input: zio.aws.databrew.model.Input.ReadOnly
    def lastModifiedDate: Option[Date]
    def lastModifiedBy: Option[LastModifiedBy]
    def source: Option[zio.aws.databrew.model.Source]
    def pathOptions: Option[zio.aws.databrew.model.PathOptions.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def resourceArn: Option[Arn]
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.InputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getInput: ZIO[Any, Nothing, zio.aws.databrew.model.Input.ReadOnly] =
      ZIO.succeed(input)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getSource: ZIO[Any, AwsError, zio.aws.databrew.model.Source] =
      AwsError.unwrapOptionField("source", source)
    def getPathOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.PathOptions.ReadOnly] =
      AwsError.unwrapOptionField("pathOptions", pathOptions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse
  ) extends zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly {
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
    override val format: Option[zio.aws.databrew.model.InputFormat] = scala
      .Option(impl.format())
      .map(value => zio.aws.databrew.model.InputFormat.wrap(value))
    override val formatOptions
        : Option[zio.aws.databrew.model.FormatOptions.ReadOnly] = scala
      .Option(impl.formatOptions())
      .map(value => zio.aws.databrew.model.FormatOptions.wrap(value))
    override val input: zio.aws.databrew.model.Input.ReadOnly =
      zio.aws.databrew.model.Input.wrap(impl.input())
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val source: Option[zio.aws.databrew.model.Source] = scala
      .Option(impl.source())
      .map(value => zio.aws.databrew.model.Source.wrap(value))
    override val pathOptions
        : Option[zio.aws.databrew.model.PathOptions.ReadOnly] = scala
      .Option(impl.pathOptions())
      .map(value => zio.aws.databrew.model.PathOptions.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeDatasetResponse
  ): zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly = new Wrapper(impl)
}
