package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ProjectName
import scala.jdk.CollectionConverters.*
final case class CreateProjectResponse(name: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateProjectResponse
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateProjectResponse.ReadOnly =
    zio.aws.databrew.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateProjectResponse =
      zio.aws.databrew.model.CreateProjectResponse(name)
    def name: ProjectName
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateProjectResponse
  ) extends zio.aws.databrew.model.CreateProjectResponse.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateProjectResponse
  ): zio.aws.databrew.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
