package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{TagValue, TagKey, DatasetName}
import scala.jdk.CollectionConverters._
final case class CreateDatasetRequest(
    name: DatasetName,
    format: Optional[zio.aws.databrew.model.InputFormat] = Optional.Absent,
    formatOptions: Optional[zio.aws.databrew.model.FormatOptions] =
      Optional.Absent,
    input: zio.aws.databrew.model.Input,
    pathOptions: Optional[zio.aws.databrew.model.PathOptions] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateDatasetRequest
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .input(input.buildAwsValue())
      .optionallyWith(pathOptions.map(value => value.buildAwsValue()))(
        _.pathOptions
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateDatasetRequest.ReadOnly =
    zio.aws.databrew.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateDatasetRequest =
      zio.aws.databrew.model.CreateDatasetRequest(
        name,
        format.map(value => value),
        formatOptions.map(value => value.asEditable),
        input.asEditable,
        pathOptions.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: DatasetName
    def format: Optional[zio.aws.databrew.model.InputFormat]
    def formatOptions: Optional[zio.aws.databrew.model.FormatOptions.ReadOnly]
    def input: zio.aws.databrew.model.Input.ReadOnly
    def pathOptions: Optional[zio.aws.databrew.model.PathOptions.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.InputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getInput: ZIO[Any, Nothing, zio.aws.databrew.model.Input.ReadOnly] =
      ZIO.succeed(input)
    def getPathOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.PathOptions.ReadOnly] =
      AwsError.unwrapOptionField("pathOptions", pathOptions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateDatasetRequest
  ) extends zio.aws.databrew.model.CreateDatasetRequest.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
    override val format: Optional[zio.aws.databrew.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.databrew.model.InputFormat.wrap(value))
    override val formatOptions
        : Optional[zio.aws.databrew.model.FormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.databrew.model.FormatOptions.wrap(value))
    override val input: zio.aws.databrew.model.Input.ReadOnly =
      zio.aws.databrew.model.Input.wrap(impl.input())
    override val pathOptions
        : Optional[zio.aws.databrew.model.PathOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathOptions())
        .map(value => zio.aws.databrew.model.PathOptions.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateDatasetRequest
  ): zio.aws.databrew.model.CreateDatasetRequest.ReadOnly = new Wrapper(impl)
}
