package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{ProjectName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateProjectRequest(
    sample: Optional[zio.aws.databrew.model.Sample] = Optional.Absent,
    roleArn: Arn,
    name: ProjectName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateProjectRequest
      .builder()
      .optionallyWith(sample.map(value => value.buildAwsValue()))(_.sample)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateProjectRequest.ReadOnly =
    zio.aws.databrew.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateProjectRequest =
      zio.aws.databrew.model.UpdateProjectRequest(
        sample.map(value => value.asEditable),
        roleArn,
        name
      )
    def sample: Optional[zio.aws.databrew.model.Sample.ReadOnly]
    def roleArn: Arn
    def name: ProjectName
    def getSample: ZIO[Any, AwsError, zio.aws.databrew.model.Sample.ReadOnly] =
      AwsError.unwrapOptionField("sample", sample)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProjectRequest
  ) extends zio.aws.databrew.model.UpdateProjectRequest.ReadOnly {
    override val sample: Optional[zio.aws.databrew.model.Sample.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sample())
        .map(value => zio.aws.databrew.model.Sample.wrap(value))
    override val roleArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.roleArn())
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProjectRequest
  ): zio.aws.databrew.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
