package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{
  Disabled,
  ValueReference,
  RuleName,
  Expression,
  ConditionValue
}
import scala.jdk.CollectionConverters._
final case class Rule(
    name: RuleName,
    disabled: Optional[Disabled] = Optional.Absent,
    checkExpression: Expression,
    substitutionMap: Optional[Map[ValueReference, ConditionValue]] =
      Optional.Absent,
    threshold: Optional[zio.aws.databrew.model.Threshold] = Optional.Absent,
    columnSelectors: Optional[Iterable[zio.aws.databrew.model.ColumnSelector]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Rule
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        disabled.map(value => Disabled.unwrap(value): java.lang.Boolean)
      )(_.disabled)
      .checkExpression(Expression.unwrap(checkExpression): java.lang.String)
      .optionallyWith(
        substitutionMap.map(value =>
          value
            .map({ case (key, value) =>
              (ValueReference.unwrap(key): java.lang.String) -> (ConditionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.substitutionMap)
      .optionallyWith(threshold.map(value => value.buildAwsValue()))(
        _.threshold
      )
      .optionallyWith(
        columnSelectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnSelectors)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Rule.ReadOnly =
    zio.aws.databrew.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Rule = zio.aws.databrew.model.Rule(
      name,
      disabled.map(value => value),
      checkExpression,
      substitutionMap.map(value => value),
      threshold.map(value => value.asEditable),
      columnSelectors.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def name: RuleName
    def disabled: Optional[Disabled]
    def checkExpression: Expression
    def substitutionMap: Optional[Map[ValueReference, ConditionValue]]
    def threshold: Optional[zio.aws.databrew.model.Threshold.ReadOnly]
    def columnSelectors
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getDisabled: ZIO[Any, AwsError, Disabled] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getCheckExpression: ZIO[Any, Nothing, Expression] =
      ZIO.succeed(checkExpression)
    def getSubstitutionMap
        : ZIO[Any, AwsError, Map[ValueReference, ConditionValue]] =
      AwsError.unwrapOptionField("substitutionMap", substitutionMap)
    def getThreshold
        : ZIO[Any, AwsError, zio.aws.databrew.model.Threshold.ReadOnly] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getColumnSelectors: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("columnSelectors", columnSelectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Rule
  ) extends zio.aws.databrew.model.Rule.ReadOnly {
    override val name: RuleName =
      zio.aws.databrew.model.primitives.RuleName(impl.name())
    override val disabled: Optional[Disabled] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => zio.aws.databrew.model.primitives.Disabled(value))
    override val checkExpression: Expression =
      zio.aws.databrew.model.primitives.Expression(impl.checkExpression())
    override val substitutionMap
        : Optional[Map[ValueReference, ConditionValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.substitutionMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives.ValueReference(
              key
            ) -> zio.aws.databrew.model.primitives.ConditionValue(value)
          })
          .toMap
      )
    override val threshold
        : Optional[zio.aws.databrew.model.Threshold.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threshold())
        .map(value => zio.aws.databrew.model.Threshold.wrap(value))
    override val columnSelectors
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnSelectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.ColumnSelector.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Rule
  ): zio.aws.databrew.model.Rule.ReadOnly = new Wrapper(impl)
}
