package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters._
final case class UpdateRecipeJobResponse(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse = {
    import UpdateRecipeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly =
    zio.aws.databrew.model.UpdateRecipeJobResponse.wrap(buildAwsValue())
}
object UpdateRecipeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRecipeJobResponse =
      zio.aws.databrew.model.UpdateRecipeJobResponse(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse
  ) extends zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeJobResponse
  ): zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly = new Wrapper(impl)
}
