package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{
  TagValue,
  TagKey,
  RecipeName,
  RecipeDescription
}
import scala.jdk.CollectionConverters._
final case class CreateRecipeRequest(
    description: Optional[RecipeDescription] = Optional.Absent,
    name: RecipeName,
    steps: Iterable[zio.aws.databrew.model.RecipeStep],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRecipeRequest = {
    import CreateRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRecipeRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          RecipeDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(RecipeName.unwrap(name): java.lang.String)
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRecipeRequest.ReadOnly =
    zio.aws.databrew.model.CreateRecipeRequest.wrap(buildAwsValue())
}
object CreateRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRecipeRequest =
      zio.aws.databrew.model.CreateRecipeRequest(
        description.map(value => value),
        name,
        steps.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def description: Optional[RecipeDescription]
    def name: RecipeName
    def steps: List[zio.aws.databrew.model.RecipeStep.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, RecipeDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getSteps
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.RecipeStep.ReadOnly]] =
      ZIO.succeed(steps)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeRequest
  ) extends zio.aws.databrew.model.CreateRecipeRequest.ReadOnly {
    override val description: Optional[RecipeDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.databrew.model.primitives.RecipeDescription(value)
        )
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val steps: List[zio.aws.databrew.model.RecipeStep.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.databrew.model.RecipeStep.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeRequest
  ): zio.aws.databrew.model.CreateRecipeRequest.ReadOnly = new Wrapper(impl)
}
