package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ProjectName
import scala.jdk.CollectionConverters._
final case class DeleteProjectResponse(name: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteProjectResponse = {
    import DeleteProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteProjectResponse
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteProjectResponse.ReadOnly =
    zio.aws.databrew.model.DeleteProjectResponse.wrap(buildAwsValue())
}
object DeleteProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteProjectResponse =
      zio.aws.databrew.model.DeleteProjectResponse(name)
    def name: ProjectName
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteProjectResponse
  ) extends zio.aws.databrew.model.DeleteProjectResponse.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteProjectResponse
  ): zio.aws.databrew.model.DeleteProjectResponse.ReadOnly = new Wrapper(impl)
}
