package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  ColumnRange,
  RowRange,
  ColumnName,
  StartColumnIndex,
  StartRowIndex
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ViewFrame(
    startColumnIndex: StartColumnIndex,
    columnRange: Optional[ColumnRange] = Optional.Absent,
    hiddenColumns: Optional[Iterable[ColumnName]] = Optional.Absent,
    startRowIndex: Optional[StartRowIndex] = Optional.Absent,
    rowRange: Optional[RowRange] = Optional.Absent,
    analytics: Optional[zio.aws.databrew.model.AnalyticsMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ViewFrame = {
    import ViewFrame.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ViewFrame
      .builder()
      .startColumnIndex(StartColumnIndex.unwrap(startColumnIndex): Integer)
      .optionallyWith(
        columnRange.map(value => ColumnRange.unwrap(value): Integer)
      )(_.columnRange)
      .optionallyWith(
        hiddenColumns.map(value =>
          value.map { item =>
            ColumnName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hiddenColumns)
      .optionallyWith(
        startRowIndex.map(value => StartRowIndex.unwrap(value): Integer)
      )(_.startRowIndex)
      .optionallyWith(rowRange.map(value => RowRange.unwrap(value): Integer))(
        _.rowRange
      )
      .optionallyWith(analytics.map(value => value.unwrap))(_.analytics)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ViewFrame.ReadOnly =
    zio.aws.databrew.model.ViewFrame.wrap(buildAwsValue())
}
object ViewFrame {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ViewFrame
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ViewFrame =
      zio.aws.databrew.model.ViewFrame(
        startColumnIndex,
        columnRange.map(value => value),
        hiddenColumns.map(value => value),
        startRowIndex.map(value => value),
        rowRange.map(value => value),
        analytics.map(value => value)
      )
    def startColumnIndex: StartColumnIndex
    def columnRange: Optional[ColumnRange]
    def hiddenColumns: Optional[List[ColumnName]]
    def startRowIndex: Optional[StartRowIndex]
    def rowRange: Optional[RowRange]
    def analytics: Optional[zio.aws.databrew.model.AnalyticsMode]
    def getStartColumnIndex: ZIO[Any, Nothing, StartColumnIndex] =
      ZIO.succeed(startColumnIndex)
    def getColumnRange: ZIO[Any, AwsError, ColumnRange] =
      AwsError.unwrapOptionField("columnRange", columnRange)
    def getHiddenColumns: ZIO[Any, AwsError, List[ColumnName]] =
      AwsError.unwrapOptionField("hiddenColumns", hiddenColumns)
    def getStartRowIndex: ZIO[Any, AwsError, StartRowIndex] =
      AwsError.unwrapOptionField("startRowIndex", startRowIndex)
    def getRowRange: ZIO[Any, AwsError, RowRange] =
      AwsError.unwrapOptionField("rowRange", rowRange)
    def getAnalytics: ZIO[Any, AwsError, zio.aws.databrew.model.AnalyticsMode] =
      AwsError.unwrapOptionField("analytics", analytics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ViewFrame
  ) extends zio.aws.databrew.model.ViewFrame.ReadOnly {
    override val startColumnIndex: StartColumnIndex =
      zio.aws.databrew.model.primitives
        .StartColumnIndex(impl.startColumnIndex())
    override val columnRange: Optional[ColumnRange] = zio.aws.core.internal
      .optionalFromNullable(impl.columnRange())
      .map(value => zio.aws.databrew.model.primitives.ColumnRange(value))
    override val hiddenColumns: Optional[List[ColumnName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hiddenColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.primitives.ColumnName(item)
          }.toList
        )
    override val startRowIndex: Optional[StartRowIndex] = zio.aws.core.internal
      .optionalFromNullable(impl.startRowIndex())
      .map(value => zio.aws.databrew.model.primitives.StartRowIndex(value))
    override val rowRange: Optional[RowRange] = zio.aws.core.internal
      .optionalFromNullable(impl.rowRange())
      .map(value => zio.aws.databrew.model.primitives.RowRange(value))
    override val analytics: Optional[zio.aws.databrew.model.AnalyticsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analytics())
        .map(value => zio.aws.databrew.model.AnalyticsMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ViewFrame
  ): zio.aws.databrew.model.ViewFrame.ReadOnly = new Wrapper(impl)
}
