package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters._
final case class UpdateProfileJobResponse(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse = {
    import UpdateProfileJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateProfileJobResponse.ReadOnly =
    zio.aws.databrew.model.UpdateProfileJobResponse.wrap(buildAwsValue())
}
object UpdateProfileJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateProfileJobResponse =
      zio.aws.databrew.model.UpdateProfileJobResponse(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse
  ) extends zio.aws.databrew.model.UpdateProfileJobResponse.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProfileJobResponse
  ): zio.aws.databrew.model.UpdateProfileJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
