package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait JobRunState {
  def unwrap: software.amazon.awssdk.services.databrew.model.JobRunState
}
object JobRunState {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.JobRunState
  ): zio.aws.databrew.model.JobRunState = value match {
    case software.amazon.awssdk.services.databrew.model.JobRunState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.databrew.model.JobRunState.TIMEOUT =>
      val r = TIMEOUT
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.STARTING
  }
  case object RUNNING extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.RUNNING
  }
  case object STOPPING extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.STOPPING
  }
  case object STOPPED extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.STOPPED
  }
  case object SUCCEEDED extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.SUCCEEDED
  }
  case object FAILED extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.FAILED
  }
  case object TIMEOUT extends zio.aws.databrew.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.JobRunState =
      software.amazon.awssdk.services.databrew.model.JobRunState.TIMEOUT
  }
}
