package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{RecipeVersion, RecipeName}
import scala.jdk.CollectionConverters._
final case class DeleteRecipeVersionRequest(
    name: RecipeName,
    recipeVersion: RecipeVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest = {
    import DeleteRecipeVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .recipeVersion(RecipeVersion.unwrap(recipeVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteRecipeVersionRequest.ReadOnly =
    zio.aws.databrew.model.DeleteRecipeVersionRequest.wrap(buildAwsValue())
}
object DeleteRecipeVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteRecipeVersionRequest =
      zio.aws.databrew.model.DeleteRecipeVersionRequest(name, recipeVersion)
    def name: RecipeName
    def recipeVersion: RecipeVersion
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getRecipeVersion: ZIO[Any, Nothing, RecipeVersion] =
      ZIO.succeed(recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest
  ) extends zio.aws.databrew.model.DeleteRecipeVersionRequest.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val recipeVersion: RecipeVersion =
      zio.aws.databrew.model.primitives.RecipeVersion(impl.recipeVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionRequest
  ): zio.aws.databrew.model.DeleteRecipeVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
