package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ProjectName
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(name: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteProjectRequest
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteProjectRequest.ReadOnly =
    zio.aws.databrew.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteProjectRequest =
      zio.aws.databrew.model.DeleteProjectRequest(name)
    def name: ProjectName
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteProjectRequest
  ) extends zio.aws.databrew.model.DeleteProjectRequest.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteProjectRequest
  ): zio.aws.databrew.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
