package zio.aws.databrew
import zio.aws.databrew.model.UpdateProfileJobResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.databrew.model.{
  CreateRecipeJobRequest,
  PublishRecipeRequest,
  ListRecipeVersionsRequest,
  ListRulesetsRequest,
  CreateDatasetRequest,
  ListSchedulesRequest,
  CreateProjectRequest,
  CreateProfileJobRequest,
  StartProjectSessionRequest,
  ListJobRunsRequest,
  ListJobsRequest,
  DeleteScheduleRequest,
  StartJobRunRequest,
  DescribeJobRunRequest,
  DescribeJobRequest,
  DescribeDatasetRequest,
  ListTagsForResourceRequest,
  DescribeRecipeRequest,
  StopJobRunRequest,
  CreateScheduleRequest,
  DeleteRulesetRequest,
  UpdateProjectRequest,
  ListDatasetsRequest,
  DeleteJobRequest,
  CreateRulesetRequest,
  DeleteProjectRequest,
  UpdateRecipeRequest,
  DescribeRulesetRequest,
  DeleteDatasetRequest,
  SendProjectSessionActionRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  BatchDeleteRecipeVersionRequest,
  CreateRecipeRequest,
  ListRecipesRequest,
  UpdateRulesetRequest,
  UpdateDatasetRequest,
  UpdateScheduleRequest,
  DescribeProjectRequest,
  TagResourceRequest,
  DeleteRecipeVersionRequest,
  UpdateProfileJobRequest,
  DescribeScheduleRequest,
  UpdateRecipeJobRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient
import zio.stream.ZStream
object DataBrewMock extends Mock[DataBrew] {
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.databrew.model.CreateDatasetResponse.ReadOnly
      ]
  object BatchDeleteRecipeVersion
      extends Effect[
        BatchDeleteRecipeVersionRequest,
        AwsError,
        zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly
      ]
  object DescribeJob
      extends Effect[
        DescribeJobRequest,
        AwsError,
        zio.aws.databrew.model.DescribeJobResponse.ReadOnly
      ]
  object CreateSchedule
      extends Effect[
        CreateScheduleRequest,
        AwsError,
        zio.aws.databrew.model.CreateScheduleResponse.ReadOnly
      ]
  object ListSchedules
      extends Stream[
        ListSchedulesRequest,
        AwsError,
        zio.aws.databrew.model.Schedule.ReadOnly
      ]
  object ListSchedulesPaginated
      extends Effect[
        ListSchedulesRequest,
        AwsError,
        zio.aws.databrew.model.ListSchedulesResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.databrew.model.UpdateProjectResponse.ReadOnly
      ]
  object DescribeJobRun
      extends Effect[
        DescribeJobRunRequest,
        AwsError,
        zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly
      ]
  object ListJobRuns
      extends Stream[
        ListJobRunsRequest,
        AwsError,
        zio.aws.databrew.model.JobRun.ReadOnly
      ]
  object ListJobRunsPaginated
      extends Effect[
        ListJobRunsRequest,
        AwsError,
        zio.aws.databrew.model.ListJobRunsResponse.ReadOnly
      ]
  object CreateRuleset
      extends Effect[
        CreateRulesetRequest,
        AwsError,
        zio.aws.databrew.model.CreateRulesetResponse.ReadOnly
      ]
  object UpdateSchedule
      extends Effect[
        UpdateScheduleRequest,
        AwsError,
        zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly
      ]
  object DeleteRuleset
      extends Effect[
        DeleteRulesetRequest,
        AwsError,
        zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly
      ]
  object StopJobRun
      extends Effect[
        StopJobRunRequest,
        AwsError,
        zio.aws.databrew.model.StopJobRunResponse.ReadOnly
      ]
  object ListRulesets
      extends Stream[
        ListRulesetsRequest,
        AwsError,
        zio.aws.databrew.model.RulesetItem.ReadOnly
      ]
  object ListRulesetsPaginated
      extends Effect[
        ListRulesetsRequest,
        AwsError,
        zio.aws.databrew.model.ListRulesetsResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.databrew.model.Project.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.databrew.model.ListProjectsResponse.ReadOnly
      ]
  object CreateProfileJob
      extends Effect[
        CreateProfileJobRequest,
        AwsError,
        zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly
      ]
  object DescribeRecipe
      extends Effect[
        DescribeRecipeRequest,
        AwsError,
        zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly
      ]
  object UpdateRecipeJob
      extends Effect[
        UpdateRecipeJobRequest,
        AwsError,
        zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly
      ]
  object UpdateDataset
      extends Effect[
        UpdateDatasetRequest,
        AwsError,
        zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly
      ]
  object DescribeRuleset
      extends Effect[
        DescribeRulesetRequest,
        AwsError,
        zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.databrew.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.databrew.model.CreateProjectResponse.ReadOnly
      ]
  object SendProjectSessionAction
      extends Effect[
        SendProjectSessionActionRequest,
        AwsError,
        zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly
      ]
  object StartProjectSession
      extends Effect[
        StartProjectSessionRequest,
        AwsError,
        zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly
      ]
  object DescribeSchedule
      extends Effect[
        DescribeScheduleRequest,
        AwsError,
        zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly
      ]
  object UpdateRecipe
      extends Effect[
        UpdateRecipeRequest,
        AwsError,
        zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.databrew.model.Dataset.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.databrew.model.ListDatasetsResponse.ReadOnly
      ]
  object UpdateRuleset
      extends Effect[
        UpdateRulesetRequest,
        AwsError,
        zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.databrew.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateRecipe
      extends Effect[
        CreateRecipeRequest,
        AwsError,
        zio.aws.databrew.model.CreateRecipeResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.databrew.model.DescribeProjectResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.databrew.model.Job.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.databrew.model.ListJobsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.databrew.model.TagResourceResponse.ReadOnly
      ]
  object UpdateProfileJob
      extends Effect[UpdateProfileJobRequest, AwsError, ReadOnly]
  object CreateRecipeJob
      extends Effect[
        CreateRecipeJobRequest,
        AwsError,
        zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly
      ]
  object DeleteRecipeVersion
      extends Effect[
        DeleteRecipeVersionRequest,
        AwsError,
        zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.databrew.model.DeleteProjectResponse.ReadOnly
      ]
  object DeleteSchedule
      extends Effect[
        DeleteScheduleRequest,
        AwsError,
        zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly
      ]
  object StartJobRun
      extends Effect[
        StartJobRunRequest,
        AwsError,
        zio.aws.databrew.model.StartJobRunResponse.ReadOnly
      ]
  object ListRecipeVersions
      extends Stream[
        ListRecipeVersionsRequest,
        AwsError,
        zio.aws.databrew.model.Recipe.ReadOnly
      ]
  object ListRecipeVersionsPaginated
      extends Effect[
        ListRecipeVersionsRequest,
        AwsError,
        zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly
      ]
  object DeleteJob
      extends Effect[
        DeleteJobRequest,
        AwsError,
        zio.aws.databrew.model.DeleteJobResponse.ReadOnly
      ]
  object PublishRecipe
      extends Effect[
        PublishRecipeRequest,
        AwsError,
        zio.aws.databrew.model.PublishRecipeResponse.ReadOnly
      ]
  object ListRecipes
      extends Stream[
        ListRecipesRequest,
        AwsError,
        zio.aws.databrew.model.Recipe.ReadOnly
      ]
  object ListRecipesPaginated
      extends Effect[
        ListRecipesRequest,
        AwsError,
        zio.aws.databrew.model.ListRecipesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DataBrew] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DataBrew {
          val api: DataBrewAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DataBrew = this
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def batchDeleteRecipeVersion(
              request: BatchDeleteRecipeVersionRequest
          ): IO[
            AwsError,
            zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly
          ] = proxy(BatchDeleteRecipeVersion, request)
          def describeJob(
              request: DescribeJobRequest
          ): IO[AwsError, zio.aws.databrew.model.DescribeJobResponse.ReadOnly] =
            proxy(DescribeJob, request)
          def createSchedule(request: CreateScheduleRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateScheduleResponse.ReadOnly
          ] = proxy(CreateSchedule, request)
          def listSchedules(
              request: ListSchedulesRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Schedule.ReadOnly] =
            rts.unsafeRun(proxy(ListSchedules, request))
          def listSchedulesPaginated(request: ListSchedulesRequest): IO[
            AwsError,
            zio.aws.databrew.model.ListSchedulesResponse.ReadOnly
          ] = proxy(ListSchedulesPaginated, request)
          def updateProject(request: UpdateProjectRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateProjectResponse.ReadOnly
          ] = proxy(UpdateProject, request)
          def describeJobRun(request: DescribeJobRunRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly
          ] = proxy(DescribeJobRun, request)
          def listJobRuns(
              request: ListJobRunsRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.JobRun.ReadOnly] =
            rts.unsafeRun(proxy(ListJobRuns, request))
          def listJobRunsPaginated(
              request: ListJobRunsRequest
          ): IO[AwsError, zio.aws.databrew.model.ListJobRunsResponse.ReadOnly] =
            proxy(ListJobRunsPaginated, request)
          def createRuleset(request: CreateRulesetRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateRulesetResponse.ReadOnly
          ] = proxy(CreateRuleset, request)
          def updateSchedule(request: UpdateScheduleRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly
          ] = proxy(UpdateSchedule, request)
          def deleteRuleset(request: DeleteRulesetRequest): IO[
            AwsError,
            zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly
          ] = proxy(DeleteRuleset, request)
          def stopJobRun(
              request: StopJobRunRequest
          ): IO[AwsError, zio.aws.databrew.model.StopJobRunResponse.ReadOnly] =
            proxy(StopJobRun, request)
          def listRulesets(request: ListRulesetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.databrew.model.RulesetItem.ReadOnly
          ] = rts.unsafeRun(proxy(ListRulesets, request))
          def listRulesetsPaginated(request: ListRulesetsRequest): IO[
            AwsError,
            zio.aws.databrew.model.ListRulesetsResponse.ReadOnly
          ] = proxy(ListRulesetsPaginated, request)
          def describeDataset(request: DescribeDatasetRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly
          ] = proxy(DescribeDataset, request)
          def listProjects(
              request: ListProjectsRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Project.ReadOnly] =
            rts.unsafeRun(proxy(ListProjects, request))
          def listProjectsPaginated(request: ListProjectsRequest): IO[
            AwsError,
            zio.aws.databrew.model.ListProjectsResponse.ReadOnly
          ] = proxy(ListProjectsPaginated, request)
          def createProfileJob(request: CreateProfileJobRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly
          ] = proxy(CreateProfileJob, request)
          def describeRecipe(request: DescribeRecipeRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly
          ] = proxy(DescribeRecipe, request)
          def updateRecipeJob(request: UpdateRecipeJobRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly
          ] = proxy(UpdateRecipeJob, request)
          def updateDataset(request: UpdateDatasetRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly
          ] = proxy(UpdateDataset, request)
          def describeRuleset(request: DescribeRulesetRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly
          ] = proxy(DescribeRuleset, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.databrew.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createProject(request: CreateProjectRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateProjectResponse.ReadOnly
          ] = proxy(CreateProject, request)
          def sendProjectSessionAction(
              request: SendProjectSessionActionRequest
          ): IO[
            AwsError,
            zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly
          ] = proxy(SendProjectSessionAction, request)
          def startProjectSession(request: StartProjectSessionRequest): IO[
            AwsError,
            zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly
          ] = proxy(StartProjectSession, request)
          def describeSchedule(request: DescribeScheduleRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly
          ] = proxy(DescribeSchedule, request)
          def updateRecipe(request: UpdateRecipeRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly
          ] = proxy(UpdateRecipe, request)
          def listDatasets(
              request: ListDatasetsRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Dataset.ReadOnly] =
            rts.unsafeRun(proxy(ListDatasets, request))
          def listDatasetsPaginated(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.databrew.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasetsPaginated, request)
          def updateRuleset(request: UpdateRulesetRequest): IO[
            AwsError,
            zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly
          ] = proxy(UpdateRuleset, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.databrew.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def createRecipe(request: CreateRecipeRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateRecipeResponse.ReadOnly
          ] = proxy(CreateRecipe, request)
          def describeProject(request: DescribeProjectRequest): IO[
            AwsError,
            zio.aws.databrew.model.DescribeProjectResponse.ReadOnly
          ] = proxy(DescribeProject, request)
          def listJobs(
              request: ListJobsRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Job.ReadOnly] =
            rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.databrew.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.databrew.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateProfileJob(
              request: UpdateProfileJobRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateProfileJob, request)
          def createRecipeJob(request: CreateRecipeJobRequest): IO[
            AwsError,
            zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly
          ] = proxy(CreateRecipeJob, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[
            AwsError,
            zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly
          ] = proxy(DeleteDataset, request)
          def deleteRecipeVersion(request: DeleteRecipeVersionRequest): IO[
            AwsError,
            zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly
          ] = proxy(DeleteRecipeVersion, request)
          def deleteProject(request: DeleteProjectRequest): IO[
            AwsError,
            zio.aws.databrew.model.DeleteProjectResponse.ReadOnly
          ] = proxy(DeleteProject, request)
          def deleteSchedule(request: DeleteScheduleRequest): IO[
            AwsError,
            zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly
          ] = proxy(DeleteSchedule, request)
          def startJobRun(
              request: StartJobRunRequest
          ): IO[AwsError, zio.aws.databrew.model.StartJobRunResponse.ReadOnly] =
            proxy(StartJobRun, request)
          def listRecipeVersions(
              request: ListRecipeVersionsRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly] =
            rts.unsafeRun(proxy(ListRecipeVersions, request))
          def listRecipeVersionsPaginated(
              request: ListRecipeVersionsRequest
          ): IO[
            AwsError,
            zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly
          ] = proxy(ListRecipeVersionsPaginated, request)
          def deleteJob(
              request: DeleteJobRequest
          ): IO[AwsError, zio.aws.databrew.model.DeleteJobResponse.ReadOnly] =
            proxy(DeleteJob, request)
          def publishRecipe(request: PublishRecipeRequest): IO[
            AwsError,
            zio.aws.databrew.model.PublishRecipeResponse.ReadOnly
          ] = proxy(PublishRecipe, request)
          def listRecipes(
              request: ListRecipesRequest
          ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly] =
            rts.unsafeRun(proxy(ListRecipes, request))
          def listRecipesPaginated(
              request: ListRecipesRequest
          ): IO[AwsError, zio.aws.databrew.model.ListRecipesResponse.ReadOnly] =
            proxy(ListRecipesPaginated, request)
        }
      }
    }
  }
}
