package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RecipeName
import scala.jdk.CollectionConverters._
final case class CreateRecipeResponse(name: RecipeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRecipeResponse = {
    import CreateRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRecipeResponse
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRecipeResponse.ReadOnly =
    zio.aws.databrew.model.CreateRecipeResponse.wrap(buildAwsValue())
}
object CreateRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRecipeResponse =
      zio.aws.databrew.model.CreateRecipeResponse(name)
    def name: RecipeName
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeResponse
  ) extends zio.aws.databrew.model.CreateRecipeResponse.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeResponse
  ): zio.aws.databrew.model.CreateRecipeResponse.ReadOnly = new Wrapper(impl)
}
