package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{RecipeName, RecipeDescription}
import scala.jdk.CollectionConverters._
final case class UpdateRecipeRequest(
    description: Option[RecipeDescription] = None,
    name: RecipeName,
    steps: Option[Iterable[zio.aws.databrew.model.RecipeStep]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest = {
    import UpdateRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          RecipeDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(RecipeName.unwrap(name): java.lang.String)
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRecipeRequest.ReadOnly =
    zio.aws.databrew.model.UpdateRecipeRequest.wrap(buildAwsValue())
}
object UpdateRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRecipeRequest =
      zio.aws.databrew.model.UpdateRecipeRequest(
        description.map(value => value),
        name,
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[RecipeDescription]
    def name: RecipeName
    def steps: Option[List[zio.aws.databrew.model.RecipeStep.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, RecipeDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.RecipeStep.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest
  ) extends zio.aws.databrew.model.UpdateRecipeRequest.ReadOnly {
    override val description: Option[RecipeDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.databrew.model.primitives.RecipeDescription(value))
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val steps
        : Option[List[zio.aws.databrew.model.RecipeStep.ReadOnly]] = scala
      .Option(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.RecipeStep.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeRequest
  ): zio.aws.databrew.model.UpdateRecipeRequest.ReadOnly = new Wrapper(impl)
}
