package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{RecipeName, RecipeDescription}
import scala.jdk.CollectionConverters._
final case class PublishRecipeRequest(
    description: Option[RecipeDescription] = None,
    name: RecipeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.PublishRecipeRequest = {
    import PublishRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.PublishRecipeRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          RecipeDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.PublishRecipeRequest.ReadOnly =
    zio.aws.databrew.model.PublishRecipeRequest.wrap(buildAwsValue())
}
object PublishRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.PublishRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.PublishRecipeRequest =
      zio.aws.databrew.model
        .PublishRecipeRequest(description.map(value => value), name)
    def description: Option[RecipeDescription]
    def name: RecipeName
    def getDescription: ZIO[Any, AwsError, RecipeDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.PublishRecipeRequest
  ) extends zio.aws.databrew.model.PublishRecipeRequest.ReadOnly {
    override val description: Option[RecipeDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.databrew.model.primitives.RecipeDescription(value))
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.PublishRecipeRequest
  ): zio.aws.databrew.model.PublishRecipeRequest.ReadOnly = new Wrapper(impl)
}
