package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  RulesetDescription,
  Arn,
  RulesetName,
  CreatedBy,
  RuleCount,
  TagKey
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RulesetItem(
    accountId: Option[AccountId] = None,
    createdBy: Option[CreatedBy] = None,
    createDate: Option[Date] = None,
    description: Option[RulesetDescription] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    lastModifiedDate: Option[Date] = None,
    name: RulesetName,
    resourceArn: Option[Arn] = None,
    ruleCount: Option[RuleCount] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    targetArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RulesetItem = {
    import RulesetItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RulesetItem
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(ruleCount.map(value => RuleCount.unwrap(value): Integer))(
        _.ruleCount
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RulesetItem.ReadOnly =
    zio.aws.databrew.model.RulesetItem.wrap(buildAwsValue())
}
object RulesetItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RulesetItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RulesetItem =
      zio.aws.databrew.model.RulesetItem(
        accountId.map(value => value),
        createdBy.map(value => value),
        createDate.map(value => value),
        description.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        name,
        resourceArn.map(value => value),
        ruleCount.map(value => value),
        tags.map(value => value),
        targetArn
      )
    def accountId: Option[AccountId]
    def createdBy: Option[CreatedBy]
    def createDate: Option[Date]
    def description: Option[RulesetDescription]
    def lastModifiedBy: Option[LastModifiedBy]
    def lastModifiedDate: Option[Date]
    def name: RulesetName
    def resourceArn: Option[Arn]
    def ruleCount: Option[RuleCount]
    def tags: Option[Map[TagKey, TagValue]]
    def targetArn: Arn
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRuleCount: ZIO[Any, AwsError, RuleCount] =
      AwsError.unwrapOptionField("ruleCount", ruleCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RulesetItem
  ) extends zio.aws.databrew.model.RulesetItem.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val description: Option[RulesetDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.databrew.model.primitives.RulesetDescription(value))
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val ruleCount: Option[RuleCount] = scala
      .Option(impl.ruleCount())
      .map(value => zio.aws.databrew.model.primitives.RuleCount(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val targetArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.targetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RulesetItem
  ): zio.aws.databrew.model.RulesetItem.ReadOnly = new Wrapper(impl)
}
