package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait Order {
  def unwrap: software.amazon.awssdk.services.databrew.model.Order
}
object Order {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.Order
  ): zio.aws.databrew.model.Order = value match {
    case software.amazon.awssdk.services.databrew.model.Order.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.Order.DESCENDING =>
      val r = DESCENDING
      r
    case software.amazon.awssdk.services.databrew.model.Order.ASCENDING =>
      val r = ASCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.Order {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Order =
      software.amazon.awssdk.services.databrew.model.Order.UNKNOWN_TO_SDK_VERSION
  }
  case object DESCENDING extends zio.aws.databrew.model.Order {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Order =
      software.amazon.awssdk.services.databrew.model.Order.DESCENDING
  }
  case object ASCENDING extends zio.aws.databrew.model.Order {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Order =
      software.amazon.awssdk.services.databrew.model.Order.ASCENDING
  }
}
