package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRecipeVersionsResponse(
    nextToken: Option[NextToken] = None,
    recipes: Iterable[zio.aws.databrew.model.Recipe]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse = {
    import ListRecipeVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .recipes(recipes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly =
    zio.aws.databrew.model.ListRecipeVersionsResponse.wrap(buildAwsValue())
}
object ListRecipeVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipeVersionsResponse =
      zio.aws.databrew.model.ListRecipeVersionsResponse(
        nextToken.map(value => value),
        recipes.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def recipes: List[zio.aws.databrew.model.Recipe.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecipes
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Recipe.ReadOnly]] =
      ZIO.succeed(recipes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse
  ) extends zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val recipes: List[zio.aws.databrew.model.Recipe.ReadOnly] = impl
      .recipes()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Recipe.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse
  ): zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
