package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.Statistic
import scala.jdk.CollectionConverters._
final case class StatisticsConfiguration(
    includedStatistics: Option[Iterable[Statistic]] = None,
    overrides: Option[Iterable[zio.aws.databrew.model.StatisticOverride]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StatisticsConfiguration = {
    import StatisticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
      .builder()
      .optionallyWith(
        includedStatistics.map(value =>
          value.map { item =>
            Statistic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedStatistics)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StatisticsConfiguration.ReadOnly =
    zio.aws.databrew.model.StatisticsConfiguration.wrap(buildAwsValue())
}
object StatisticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StatisticsConfiguration =
      zio.aws.databrew.model.StatisticsConfiguration(
        includedStatistics.map(value => value),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def includedStatistics: Option[List[Statistic]]
    def overrides
        : Option[List[zio.aws.databrew.model.StatisticOverride.ReadOnly]]
    def getIncludedStatistics: ZIO[Any, AwsError, List[Statistic]] =
      AwsError.unwrapOptionField("includedStatistics", includedStatistics)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.StatisticOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ) extends zio.aws.databrew.model.StatisticsConfiguration.ReadOnly {
    override val includedStatistics: Option[List[Statistic]] = scala
      .Option(impl.includedStatistics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.Statistic(item)
        }.toList
      )
    override val overrides
        : Option[List[zio.aws.databrew.model.StatisticOverride.ReadOnly]] =
      scala
        .Option(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.StatisticOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ): zio.aws.databrew.model.StatisticsConfiguration.ReadOnly = new Wrapper(impl)
}
