package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.SampleSize
import scala.jdk.CollectionConverters._
final case class Sample(
    size: Option[SampleSize] = None,
    `type`: zio.aws.databrew.model.SampleType
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Sample = {
    import Sample.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Sample
      .builder()
      .optionallyWith(size.map(value => SampleSize.unwrap(value): Integer))(
        _.size
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Sample.ReadOnly =
    zio.aws.databrew.model.Sample.wrap(buildAwsValue())
}
object Sample {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Sample] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Sample =
      zio.aws.databrew.model.Sample(size.map(value => value), `type`)
    def size: Option[SampleSize]
    def `type`: zio.aws.databrew.model.SampleType
    def getSize: ZIO[Any, AwsError, SampleSize] =
      AwsError.unwrapOptionField("size", size)
    def getType: ZIO[Any, Nothing, zio.aws.databrew.model.SampleType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Sample
  ) extends zio.aws.databrew.model.Sample.ReadOnly {
    override val size: Option[SampleSize] = scala
      .Option(impl.size())
      .map(value => zio.aws.databrew.model.primitives.SampleSize(value))
    override val `type`: zio.aws.databrew.model.SampleType =
      zio.aws.databrew.model.SampleType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Sample
  ): zio.aws.databrew.model.Sample.ReadOnly = new Wrapper(impl)
}
