package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{ScheduleName, CronExpression, JobName}
import scala.jdk.CollectionConverters._
final case class UpdateScheduleRequest(
    jobNames: Option[Iterable[JobName]] = None,
    cronExpression: CronExpression,
    name: ScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest = {
    import UpdateScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest
      .builder()
      .optionallyWith(
        jobNames.map(value =>
          value.map { item =>
            JobName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobNames)
      .cronExpression(CronExpression.unwrap(cronExpression): java.lang.String)
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateScheduleRequest.ReadOnly =
    zio.aws.databrew.model.UpdateScheduleRequest.wrap(buildAwsValue())
}
object UpdateScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateScheduleRequest =
      zio.aws.databrew.model.UpdateScheduleRequest(
        jobNames.map(value => value),
        cronExpression,
        name
      )
    def jobNames: Option[List[JobName]]
    def cronExpression: CronExpression
    def name: ScheduleName
    def getJobNames: ZIO[Any, AwsError, List[JobName]] =
      AwsError.unwrapOptionField("jobNames", jobNames)
    def getCronExpression: ZIO[Any, Nothing, CronExpression] =
      ZIO.succeed(cronExpression)
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest
  ) extends zio.aws.databrew.model.UpdateScheduleRequest.ReadOnly {
    override val jobNames: Option[List[JobName]] = scala
      .Option(impl.jobNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.JobName(item)
        }.toList
      )
    override val cronExpression: CronExpression =
      zio.aws.databrew.model.primitives.CronExpression(impl.cronExpression())
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateScheduleRequest
  ): zio.aws.databrew.model.UpdateScheduleRequest.ReadOnly = new Wrapper(impl)
}
