package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    projects: Iterable[zio.aws.databrew.model.Project],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListProjectsResponse
      .builder()
      .projects(projects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListProjectsResponse.ReadOnly =
    zio.aws.databrew.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListProjectsResponse =
      zio.aws.databrew.model.ListProjectsResponse(
        projects.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def projects: List[zio.aws.databrew.model.Project.ReadOnly]
    def nextToken: Option[NextToken]
    def getProjects
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Project.ReadOnly]] =
      ZIO.succeed(projects)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListProjectsResponse
  ) extends zio.aws.databrew.model.ListProjectsResponse.ReadOnly {
    override val projects: List[zio.aws.databrew.model.Project.ReadOnly] = impl
      .projects()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Project.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListProjectsResponse
  ): zio.aws.databrew.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
