package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.Delimiter
import scala.jdk.CollectionConverters._
final case class CsvOutputOptions(delimiter: Option[Delimiter] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CsvOutputOptions = {
    import CsvOutputOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CsvOutputOptions
      .builder()
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CsvOutputOptions.ReadOnly =
    zio.aws.databrew.model.CsvOutputOptions.wrap(buildAwsValue())
}
object CsvOutputOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CsvOutputOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CsvOutputOptions =
      zio.aws.databrew.model.CsvOutputOptions(delimiter.map(value => value))
    def delimiter: Option[Delimiter]
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CsvOutputOptions
  ) extends zio.aws.databrew.model.CsvOutputOptions.ReadOnly {
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.databrew.model.primitives.Delimiter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CsvOutputOptions
  ): zio.aws.databrew.model.CsvOutputOptions.ReadOnly = new Wrapper(impl)
}
