package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{OverwriteOutput, ColumnName}
import scala.jdk.CollectionConverters._
final case class Output(
    compressionFormat: Option[zio.aws.databrew.model.CompressionFormat] = None,
    format: Option[zio.aws.databrew.model.OutputFormat] = None,
    partitionColumns: Option[Iterable[ColumnName]] = None,
    location: zio.aws.databrew.model.S3Location,
    overwrite: Option[OverwriteOutput] = None,
    formatOptions: Option[zio.aws.databrew.model.OutputFormatOptions] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Output
      .builder()
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            ColumnName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .location(location.buildAwsValue())
      .optionallyWith(
        overwrite.map(value => OverwriteOutput.unwrap(value): java.lang.Boolean)
      )(_.overwrite)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Output.ReadOnly =
    zio.aws.databrew.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Output] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Output =
      zio.aws.databrew.model.Output(
        compressionFormat.map(value => value),
        format.map(value => value),
        partitionColumns.map(value => value),
        location.asEditable,
        overwrite.map(value => value),
        formatOptions.map(value => value.asEditable)
      )
    def compressionFormat: Option[zio.aws.databrew.model.CompressionFormat]
    def format: Option[zio.aws.databrew.model.OutputFormat]
    def partitionColumns: Option[List[ColumnName]]
    def location: zio.aws.databrew.model.S3Location.ReadOnly
    def overwrite: Option[OverwriteOutput]
    def formatOptions
        : Option[zio.aws.databrew.model.OutputFormatOptions.ReadOnly]
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.databrew.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.OutputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getPartitionColumns: ZIO[Any, AwsError, List[ColumnName]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getLocation
        : ZIO[Any, Nothing, zio.aws.databrew.model.S3Location.ReadOnly] =
      ZIO.succeed(location)
    def getOverwrite: ZIO[Any, AwsError, OverwriteOutput] =
      AwsError.unwrapOptionField("overwrite", overwrite)
    def getFormatOptions: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.OutputFormatOptions.ReadOnly
    ] = AwsError.unwrapOptionField("formatOptions", formatOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Output
  ) extends zio.aws.databrew.model.Output.ReadOnly {
    override val compressionFormat
        : Option[zio.aws.databrew.model.CompressionFormat] = scala
      .Option(impl.compressionFormat())
      .map(value => zio.aws.databrew.model.CompressionFormat.wrap(value))
    override val format: Option[zio.aws.databrew.model.OutputFormat] = scala
      .Option(impl.format())
      .map(value => zio.aws.databrew.model.OutputFormat.wrap(value))
    override val partitionColumns: Option[List[ColumnName]] = scala
      .Option(impl.partitionColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.ColumnName(item)
        }.toList
      )
    override val location: zio.aws.databrew.model.S3Location.ReadOnly =
      zio.aws.databrew.model.S3Location.wrap(impl.location())
    override val overwrite: Option[OverwriteOutput] = scala
      .Option(impl.overwrite())
      .map(value => zio.aws.databrew.model.primitives.OverwriteOutput(value))
    override val formatOptions
        : Option[zio.aws.databrew.model.OutputFormatOptions.ReadOnly] = scala
      .Option(impl.formatOptions())
      .map(value => zio.aws.databrew.model.OutputFormatOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Output
  ): zio.aws.databrew.model.Output.ReadOnly = new Wrapper(impl)
}
