package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.EntityType
import scala.jdk.CollectionConverters._
final case class EntityDetectorConfiguration(
    entityTypes: Iterable[EntityType],
    allowedStatistics: Option[
      Iterable[zio.aws.databrew.model.AllowedStatistics]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration = {
    import EntityDetectorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration
      .builder()
      .entityTypes(entityTypes.map { item =>
        EntityType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        allowedStatistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedStatistics)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly =
    zio.aws.databrew.model.EntityDetectorConfiguration.wrap(buildAwsValue())
}
object EntityDetectorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.EntityDetectorConfiguration =
      zio.aws.databrew.model.EntityDetectorConfiguration(
        entityTypes,
        allowedStatistics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entityTypes: List[EntityType]
    def allowedStatistics
        : Option[List[zio.aws.databrew.model.AllowedStatistics.ReadOnly]]
    def getEntityTypes: ZIO[Any, Nothing, List[EntityType]] =
      ZIO.succeed(entityTypes)
    def getAllowedStatistics: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.AllowedStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField("allowedStatistics", allowedStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration
  ) extends zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly {
    override val entityTypes: List[EntityType] = impl
      .entityTypes()
      .asScala
      .map { item =>
        zio.aws.databrew.model.primitives.EntityType(item)
      }
      .toList
    override val allowedStatistics
        : Option[List[zio.aws.databrew.model.AllowedStatistics.ReadOnly]] =
      scala
        .Option(impl.allowedStatistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.AllowedStatistics.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration
  ): zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
