package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  ParameterValue,
  ParameterName,
  Operation
}
import scala.jdk.CollectionConverters._
final case class RecipeAction(
    operation: Operation,
    parameters: Option[Map[ParameterName, ParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RecipeAction = {
    import RecipeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RecipeAction
      .builder()
      .operation(Operation.unwrap(operation): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RecipeAction.ReadOnly =
    zio.aws.databrew.model.RecipeAction.wrap(buildAwsValue())
}
object RecipeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RecipeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RecipeAction = zio.aws.databrew.model
      .RecipeAction(operation, parameters.map(value => value))
    def operation: Operation
    def parameters: Option[Map[ParameterName, ParameterValue]]
    def getOperation: ZIO[Any, Nothing, Operation] = ZIO.succeed(operation)
    def getParameters: ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RecipeAction
  ) extends zio.aws.databrew.model.RecipeAction.ReadOnly {
    override val operation: Operation =
      zio.aws.databrew.model.primitives.Operation(impl.operation())
    override val parameters: Option[Map[ParameterName, ParameterValue]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives.ParameterName(
              key
            ) -> zio.aws.databrew.model.primitives.ParameterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RecipeAction
  ): zio.aws.databrew.model.RecipeAction.ReadOnly = new Wrapper(impl)
}
