package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{TableName, DatabaseName, CatalogId}
import scala.jdk.CollectionConverters._
final case class DataCatalogInputDefinition(
    catalogId: Option[CatalogId] = None,
    databaseName: DatabaseName,
    tableName: TableName,
    tempDirectory: Option[zio.aws.databrew.model.S3Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition = {
    import DataCatalogInputDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogId.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(tempDirectory.map(value => value.buildAwsValue()))(
        _.tempDirectory
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly =
    zio.aws.databrew.model.DataCatalogInputDefinition.wrap(buildAwsValue())
}
object DataCatalogInputDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DataCatalogInputDefinition =
      zio.aws.databrew.model.DataCatalogInputDefinition(
        catalogId.map(value => value),
        databaseName,
        tableName,
        tempDirectory.map(value => value.asEditable)
      )
    def catalogId: Option[CatalogId]
    def databaseName: DatabaseName
    def tableName: TableName
    def tempDirectory: Option[zio.aws.databrew.model.S3Location.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogId] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getTempDirectory
        : ZIO[Any, AwsError, zio.aws.databrew.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("tempDirectory", tempDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition
  ) extends zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly {
    override val catalogId: Option[CatalogId] = scala
      .Option(impl.catalogId())
      .map(value => zio.aws.databrew.model.primitives.CatalogId(value))
    override val databaseName: DatabaseName =
      zio.aws.databrew.model.primitives.DatabaseName(impl.databaseName())
    override val tableName: TableName =
      zio.aws.databrew.model.primitives.TableName(impl.tableName())
    override val tempDirectory
        : Option[zio.aws.databrew.model.S3Location.ReadOnly] = scala
      .Option(impl.tempDirectory())
      .map(value => zio.aws.databrew.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition
  ): zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly = new Wrapper(
    impl
  )
}
