package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListSchedulesResponse(
    schedules: Iterable[zio.aws.databrew.model.Schedule],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListSchedulesResponse = {
    import ListSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListSchedulesResponse
      .builder()
      .schedules(schedules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListSchedulesResponse.ReadOnly =
    zio.aws.databrew.model.ListSchedulesResponse.wrap(buildAwsValue())
}
object ListSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListSchedulesResponse =
      zio.aws.databrew.model.ListSchedulesResponse(
        schedules.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def schedules: List[zio.aws.databrew.model.Schedule.ReadOnly]
    def nextToken: Option[NextToken]
    def getSchedules
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Schedule.ReadOnly]] =
      ZIO.succeed(schedules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesResponse
  ) extends zio.aws.databrew.model.ListSchedulesResponse.ReadOnly {
    override val schedules: List[zio.aws.databrew.model.Schedule.ReadOnly] =
      impl
        .schedules()
        .asScala
        .map { item =>
          zio.aws.databrew.model.Schedule.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListSchedulesResponse
  ): zio.aws.databrew.model.ListSchedulesResponse.ReadOnly = new Wrapper(impl)
}
