package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{ClientSessionId, ProjectName}
import scala.jdk.CollectionConverters._
final case class StartProjectSessionResponse(
    name: ProjectName,
    clientSessionId: Optional[ClientSessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse = {
    import StartProjectSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        clientSessionId.map(value =>
          ClientSessionId.unwrap(value): java.lang.String
        )
      )(_.clientSessionId)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly =
    zio.aws.databrew.model.StartProjectSessionResponse.wrap(buildAwsValue())
}
object StartProjectSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StartProjectSessionResponse =
      zio.aws.databrew.model
        .StartProjectSessionResponse(name, clientSessionId.map(value => value))
    def name: ProjectName
    def clientSessionId: Optional[ClientSessionId]
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getClientSessionId: ZIO[Any, AwsError, ClientSessionId] =
      AwsError.unwrapOptionField("clientSessionId", clientSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse
  ) extends zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val clientSessionId: Optional[ClientSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSessionId())
        .map(value => zio.aws.databrew.model.primitives.ClientSessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StartProjectSessionResponse
  ): zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
