package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.Statistic
import scala.jdk.CollectionConverters._
final case class AllowedStatistics(statistics: Iterable[Statistic]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.AllowedStatistics = {
    import AllowedStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.AllowedStatistics
      .builder()
      .statistics(statistics.map { item =>
        Statistic.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.AllowedStatistics.ReadOnly =
    zio.aws.databrew.model.AllowedStatistics.wrap(buildAwsValue())
}
object AllowedStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.AllowedStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.AllowedStatistics =
      zio.aws.databrew.model.AllowedStatistics(statistics)
    def statistics: List[Statistic]
    def getStatistics: ZIO[Any, Nothing, List[Statistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.AllowedStatistics
  ) extends zio.aws.databrew.model.AllowedStatistics.ReadOnly {
    override val statistics: List[Statistic] = impl
      .statistics()
      .asScala
      .map { item =>
        zio.aws.databrew.model.primitives.Statistic(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.AllowedStatistics
  ): zio.aws.databrew.model.AllowedStatistics.ReadOnly = new Wrapper(impl)
}
