package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters._
final case class StartJobRunRequest(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StartJobRunRequest = {
    import StartJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StartJobRunRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StartJobRunRequest.ReadOnly =
    zio.aws.databrew.model.StartJobRunRequest.wrap(buildAwsValue())
}
object StartJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StartJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StartJobRunRequest =
      zio.aws.databrew.model.StartJobRunRequest(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StartJobRunRequest
  ) extends zio.aws.databrew.model.StartJobRunRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StartJobRunRequest
  ): zio.aws.databrew.model.StartJobRunRequest.ReadOnly = new Wrapper(impl)
}
