package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait AnalyticsMode {
  def unwrap: software.amazon.awssdk.services.databrew.model.AnalyticsMode
}
object AnalyticsMode {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.AnalyticsMode
  ): zio.aws.databrew.model.AnalyticsMode = value match {
    case software.amazon.awssdk.services.databrew.model.AnalyticsMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.AnalyticsMode.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.databrew.model.AnalyticsMode.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.AnalyticsMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.AnalyticsMode =
      software.amazon.awssdk.services.databrew.model.AnalyticsMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.databrew.model.AnalyticsMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.AnalyticsMode =
      software.amazon.awssdk.services.databrew.model.AnalyticsMode.ENABLE
  }
  case object DISABLE extends zio.aws.databrew.model.AnalyticsMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.AnalyticsMode =
      software.amazon.awssdk.services.databrew.model.AnalyticsMode.DISABLE
  }
}
