package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{
  ConditionValue,
  ValueReference,
  Expression
}
import scala.jdk.CollectionConverters._
final case class FilterExpression(
    expression: Expression,
    valuesMap: Map[ValueReference, ConditionValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.FilterExpression = {
    import FilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.FilterExpression
      .builder()
      .expression(Expression.unwrap(expression): java.lang.String)
      .valuesMap(
        valuesMap
          .map({ case (key, value) =>
            (ValueReference.unwrap(key): java.lang.String) -> (ConditionValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.FilterExpression.ReadOnly =
    zio.aws.databrew.model.FilterExpression.wrap(buildAwsValue())
}
object FilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.FilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.FilterExpression =
      zio.aws.databrew.model.FilterExpression(expression, valuesMap)
    def expression: Expression
    def valuesMap: Map[ValueReference, ConditionValue]
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getValuesMap: ZIO[Any, Nothing, Map[ValueReference, ConditionValue]] =
      ZIO.succeed(valuesMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.FilterExpression
  ) extends zio.aws.databrew.model.FilterExpression.ReadOnly {
    override val expression: Expression =
      zio.aws.databrew.model.primitives.Expression(impl.expression())
    override val valuesMap: Map[ValueReference, ConditionValue] = impl
      .valuesMap()
      .asScala
      .map({ case (key, value) =>
        zio.aws.databrew.model.primitives.ValueReference(
          key
        ) -> zio.aws.databrew.model.primitives.ConditionValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.FilterExpression
  ): zio.aws.databrew.model.FilterExpression.ReadOnly = new Wrapper(impl)
}
