package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  ProjectName,
  NextToken,
  MaxResults100,
  DatasetName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    datasetName: Optional[DatasetName] = Optional.Absent,
    maxResults: Optional[MaxResults100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    projectName: Optional[ProjectName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListJobsRequest
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListJobsRequest.ReadOnly =
    zio.aws.databrew.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListJobsRequest =
      zio.aws.databrew.model.ListJobsRequest(
        datasetName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        projectName.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def maxResults: Optional[MaxResults100]
    def nextToken: Optional[NextToken]
    def projectName: Optional[ProjectName]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ) extends zio.aws.databrew.model.ListJobsRequest.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val maxResults: Optional[MaxResults100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val projectName: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.databrew.model.primitives.ProjectName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ): zio.aws.databrew.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
