package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RulesetName
import scala.jdk.CollectionConverters._
final case class CreateRulesetResponse(name: RulesetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRulesetResponse = {
    import CreateRulesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRulesetResponse
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRulesetResponse.ReadOnly =
    zio.aws.databrew.model.CreateRulesetResponse.wrap(buildAwsValue())
}
object CreateRulesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRulesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRulesetResponse =
      zio.aws.databrew.model.CreateRulesetResponse(name)
    def name: RulesetName
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRulesetResponse
  ) extends zio.aws.databrew.model.CreateRulesetResponse.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRulesetResponse
  ): zio.aws.databrew.model.CreateRulesetResponse.ReadOnly = new Wrapper(impl)
}
